<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 6 templates -->
	
<xsl:template name="Item6" >

	<h3>A. Applicant has one or more <em>associated persons</em> that is a: </h3><p><strong>Check all that apply.</strong></p>

<p><em>&quot;Associated Person&quot; herein refers to a person who is an associated person of a municipal advisor</em>.
   <em>Note that &quot;associated person&quot; includes <em>employees</em> and persons with <em>control</em> over the 
   <em>municipal advisor</em> that do not themselves engage in <em>municipal advisory activities</em>, but does not 
   include <em>employees</em> that are performing solely clerical, administrative, support or other similar functions. Note also that more than one box may be 
   applicable to any such associated person. For example, if an associated person is both a swap dealer and 
   security-based swap adviser, check both boxes (4) and (5) below.</em> </p>
<p>
  	<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Broker-dealer municipal securities dealer or government securities broker or dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (1) Broker-dealer, municipal securities dealer, or government securities broker or dealer<br />
  		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Investment Company']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
 (2) Investment company (including mutual funds) <br />
  		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Investment Adviser']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>   
  
  (3) <em>Investment adviser</em>  (including financial planners)<br />
  
  		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Swap Dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>   
  (4) Swap dealer <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Security-based swap dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (5) Security-based swap dealer <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Major swap participant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (6) Major swap participant <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Major security-based swap participant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (7) Major security-based swap participant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Commodity pool operator']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (8) Commodity pool operator (whether registered or exempt from registration) <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Commodity trading advisor']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (9) Commodity trading advisor (whether registered or exempt from registration) <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Futures commission merchant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (10) Futures commission merchant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Banking/Thrift institution']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (11) Banking or thrift institution<br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Trust Company']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (12) Trust company<br />
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Accountant or accounting firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (13) Accountant or accounting firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Lawyer or law firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (14) Attorney or law firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Insurance company or agency']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (15) Insurance company or agency <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Pension consultant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (16) Pension consultant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Real estate broker or dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (17) Real estate broker or dealer <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Sponsor or syndicator of limited partnerships']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (18) Sponsor or syndicator of limited partnerships <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Engineer or engineering firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (19) Engineer or engineering firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:fiaAssociatedPersonsTypes[m1:fiaAPTypes='Other municipal advisor']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (20) Other <em>municipal advisor</em> </p>
<h3>Total <em>Associated Persons</em>:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div style="width:800px; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle tdLabelStyle tditem5col1" style="border-bottom:none;">Provide the total number of such <em>associated persons</em>:
	</div>
    <div class="tdYesNoStyleNoBorder tditem5col2" >
		<input
					type="text"
					name="text"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:totalFIAAssociatedPersons)" />
				</xsl:attribute>
				</input>
		</div>
  </div>
  <div style="clear:both"></div>
</div>
<p><em>Provide the total number of such associated persons, not the number of boxes checked. 
For example, if the applicant's associated persons are 2 broker-dealers, 
1 investment company, and 2 pension consultants, then 3 boxes would be checked in Item 6-A.1 to 20, 
while the total number of such associated persons entered in Item 6-A., Total Associated Persons, 
would be 5. If there are no associated persons, enter 0 (zero).</em> </p>
<h3>B. <b>Applicant must list all such <em>associated persons</em>, including foreign <em>associated persons</em>, on <u>Section 6 of Schedule D.</u></b></h3>
<p><em>If Item 6-A. Total </em><em>Associated Persons</em><em>, is 2 or more, the applicant must complete a separate <u>Section 6 of Schedule D</u> for each </em><em>associated person.</em> </p>

</xsl:template>

</xsl:stylesheet>